var browser =
{
	name: null,
	version: "0",
	platform: null,
	offline: false,
	prefix: null,

	detect: function()
	{
		var user_agent = navigator.userAgent.toLowerCase();
		var name = user_agent.match(/(opera|msie|trident|firefox|chrome|crios|safari)/);
		if (name === null) this.name = "Safari";
		else
		{
			if (name[1] === "opera") this.name = "Opera";
			else if ((name[1] === "msie") || (name[1] === "trident")) this.name = "IE";
			else if (name[1] === "firefox") this.name = "Firefox";
			else if (name[1] === "chrome") this.name = "Chrome";
			else if (name[1] === "crios") this.name = "Chrome";
			else if (name[1] === "safari") this.name = "Safari";
		}

		if (this.name == "IE")
		{
			this.version = this.getVersion(user_agent, "rv:");
			if (this.version === "0") this.version = this.getVersion(user_agent, "trident/");
		}
		else if (this.name == "Firefox") this.version = this.getVersion(user_agent, "rv:");
		else if (this.name == "Chrome") this.version = this.getVersion(user_agent, "chrome/");
		else if (this.name == "Safari") this.version = this.getVersion(user_agent, "version/");
		var i = this.version.indexOf(".");
		if (i != -1) this.version = this.version.substring(0, i);

		if (user_agent.match(/(?:fvxhtml5offline)/)) this.offline = true;

		this.platform = "Android";
		if (user_agent.match(/(?:windows nt)/)) this.platform = "Intel";
		if (user_agent.match(/(?:tablet pc)/)) this.platform = "Surface";
		if (user_agent.match(/(?:media center pc)/)) this.platform = "Intel";
		if (user_agent.match(/(?:intel mac)/)) this.platform = "Intel";
		if (user_agent.match(/ip(?:ad|od|hone)/)) this.platform = "iOS";
		if (user_agent.match(/(?:ios)/)) this.platform = "iOS";
		if (user_agent.match(/(?:webos|android|bada|symbian|palm|blackberry)/)) this.platform = "Android";

		this.prefix = "";
		if (this.name === "Opera") this.prefix = "-o-";
		else if (this.name === "Safari") this.prefix = "-webkit-";
		else if (this.name === "Chrome") this.prefix = "-webkit-";
		else if (this.name === "Firefox") this.prefix = "-moz-";
		else if (this.name === "IE") this.prefix = "-ms-";
	},

	getVersion: function(user_agent, what)
	{
		var i = user_agent.indexOf(what);
		if (i == -1) return "0";
		var j = user_agent.indexOf(";", i + what.length);
		if (j == -1) j = Number.MAX_VALUE;
		var k = user_agent.indexOf(" ", i + what.length);
		if (k == -1) k = Number.MAX_VALUE;
		var m = user_agent.indexOf(")", i + what.length);
		if (m == -1) m = Number.MAX_VALUE;
		return user_agent.substring(i + what.length, Math.min(Math.min(j, k), m));
	}
};

var device =
{
	name: "",
	is_it_in_iframe: false,
	proportionally__counter: 0,

	width: function()
	{
		if (this.is_it_in_iframe) return window.innerWidth;
		else
		{
			if ((typeof window.innerWidth != "undefined") && (window.innerWidth != 0)) return window.innerWidth;
			else if ((typeof document.body.clientWidth != "undefined") && (document.body.clientWidth != 0)) return document.body.clientWidth;
			else if ((typeof document.body.offsetWidth != "undefined") && (document.body.offsetWidth != 0)) return document.body.offsetWidth;
			else screen.width;
		}
	},

	height: function()
	{
		if (this.is_it_in_iframe) return window.innerHeight;
		else
		{
			if ((typeof window.innerHeight != "undefined") && (window.innerHeight != 0)) return window.innerHeight;
			else if ((typeof document.body.clientHeight != "undefined") && (document.body.clientHeight != 0)) return document.body.clientHeight;
			else if ((typeof document.body.offsetHeight != "undefined") && (document.body.offsetHeight != 0)) return document.body.offsetHeight;
			else return Math.round(this.width() / screen.width * screen.height);
		}
	},

	detect: function()
	{
		this.is_it_in_iframe = (window.location == window.parent.location) ? false : true;
		if (this.is_it_in_iframe) {
			if (browser.platform === "Intel") this.name = "Intel";
			else if (browser.platform === "Android") this.name = "Android";
			else if (browser.platform === "iOS") this.name = "iPad";
		} else {
			if (browser.platform === "Intel") {
				this.name = "Intel";
			} else if (browser.platform === "Surface") {
				this.name = "Surface";
			} else if (browser.platform === "Android") {
				if (Math.min(window.innerWidth, window.innerHeight) <= 320) this.name = "GalaxyS2";
				else if (Math.min(window.innerWidth, window.innerHeight) <= 360) this.name = "GalaxyS3";
				else this.name = "Android";
			} else if (browser.platform === "iOS") {
				if (Math.min(window.innerWidth, window.innerHeight) <= 320) this.name = "iPhone";
				else this.name = "iPad";
			}
		}
	}
};

var observer =
{
	getOrientation: function()
	{
		if (browser.platform === "Surface") {
			return "Landscape";
		} else if (browser.platform === "iOS") {
			if (device.is_it_in_iframe) {
				if (device.width() > device.height()) return "Landscape";
				if (device.width() < device.height()) return "Portrait";
			} 

						else if (window.orientation == undefined)

	 						{				
				if (device.width() > device.height()) return "Landscape";
				if (device.width() < device.height()) return "Portrait";
				}
			else 
			{
				if ((Math.abs(window.orientation) === 0) || (Math.abs(window.orientation) === 180)) return "Portrait";
				if ((Math.abs(window.orientation) === 90) || (Math.abs(window.orientation) === -90)) return "Landscape";

								}

							}
		 else {
			if (device.width() > device.height()) return "Landscape";
			if (device.width() < device.height()) return "Portrait";
		}
	}
};

var synchronizer =
{
	since_delay: 0,
	delayOrientationChange_counter: 0,
	delayResize_counter: 0,
	resizing: null,
	device_width: 0,
	device_height: 0,

	delayOrientationChange: function()
	{
		this.delayOrientationChange_counter++;
		var that = this;
		setTimeout(function() { that.delayOrientationChange_(); }, 300);
	},

	delayOrientationChange_: function()
	{
		if (this.delayOrientationChange_counter > 1)
		{
			this.delayOrientationChange_counter--;
			return;
		}
		this.delayOrientationChange_counter = 0;

		if ((device.name === "GalaxyS2") || (device.name === "GalaxyS3"))
		{
			if (this.resizing == null)
			{
				var that = this;
				this.resizing = window.setInterval(function()
									{
										if ((that.device_width != device.width()) && (that.device_height != device.height()))
										{
											that.device_width = device.width();
											that.device_height = device.height();
											that.delayResize();
										}
									},
								300);
			}
		}

		this.delayOrientationChange__();
	},

	delayOrientationChange__: function()
	{
		if (this.since_delay < 400)
		{
			this.since_delay += 200;
			var that = this;
			setTimeout(function() { that.delayOrientationChange__(); }, 200);
			return;
		}
		this.since_delay = 0;
		$(document).trigger("orientationChange");
	},

	delayResize: function()
	{
		this.delayResize_counter++;
		var that = this;
		setTimeout(function() { that.delayResize_(); }, 1000);
	},

	delayResize_: function()
	{
		if (this.delayResize_counter > 1)
		{
			this.delayResize_counter--;
			return;
		}
		this.delayResize_counter = 0;

		this.since_delay = 400;
		window.clearInterval(this.resizing);
		this.resizing = null;
	},

	initialize: function()
	{
		if (browser.platform === "Android")
		{
			var that = this;
			window.addEventListener("orientationchange", function() { that.delayOrientationChange(); }, false);
			if ((device.name !== "GalaxyS2") && (device.name !== "GalaxyS3")) window.addEventListener("resize", function() { that.delayResize(); }, false);
		}
		else window.addEventListener("orientationchange", function() { setTimeout(function() { $(document).trigger("orientationChange"); }, 100); }, false);

	}
};